/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANT�AS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){
	//logo
	$("#rup_dept_logo").attr("src", $.rup.APP_STATICS + "/images/dept_logo_" + $.rup.lang + ".gif");
		
	//rastro de migas
	var subLevelBandejas = [
	    { "i18nCaption": "bandeja_telematicos", "url": "/ab03bAmiantoWar/ab03b09t00/filtro" }
	];
	var subLevelExpedientes = [
	    { "i18nCaption": "busqueda_expedientes", "url": "/ab03bAmiantoWar/expedientesFiltro/filtro" },
	    { "i18nCaption": "cierre_expedientes", "url": "/ab03bAmiantoWar/expedientesCierre/filtro" }
	];
	var subLevelMantenimientos = [
	    { "i18nCaption": "mantenimiento_cargos", "url": "/ab03bAmiantoWar/ab03b03t00/maint" },
	    { "i18nCaption": "mantenimiento_firmantes", "url": "/ab03bAmiantoWar/ab03b04t00/maint" },
	    { "i18nCaption": "mantenimiento_plantillas", "url": "/ab03bAmiantoWar/ab03b05t00/maint" },
	    { "i18nCaption": "mantenimiento_organismos", "url": "/ab03bAmiantoWar/ab03b39t00/maint" },
	    { "i18nCaption": "mantenimiento_tipos_material", "url": "/ab03bAmiantoWar/ab03b41t00/maint" },
	    { "i18nCaption": "mantenimiento_tipos_documentos", "url": "/ab03bAmiantoWar/ab03b44t00/maint" },
	    { "i18nCaption": "mantenimiento_tipos_trabajo", "url": "/ab03bAmiantoWar/ab03b53t00/maint" },
	    { "i18nCaption": "mantenimiento_tipos_actividad", "url": "/ab03bAmiantoWar/ab03b54t00/maint" },
	    { "i18nCaption": "mantenimiento_subtipos_actividad", "url": "/ab03bAmiantoWar/ab03b55t00/maint" }
	];
	var subLevelEstadisticas = [
	    { "i18nCaption": "estadisticas_1", "url": "/ab03bAmiantoWar/estadisticas/estadTipoPlan" },
	    { "i18nCaption": "estadisticas_2", "url": "/ab03bAmiantoWar/estadisticasINSHT/maint" },
	    { "i18nCaption": "estadisticas_3", "url": "/ab03bAmiantoWar/estadPercepcion/maint" }
	];

	$("#ab03bAmiantoWar_migas").rup_breadCrumb({
		breadCrumb: {
			"ab03b09t00": {
				"i18nCaption": "bandejas_entrada",
				"filtro": { "i18nCaption": "bandeja_telematicos" },
				"subLevel": subLevelBandejas
			},
			"expedientesFiltro": {
				"i18nCaption": "expedientes",
				"filtro": { "i18nCaption": "busqueda_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"expedientesCierre": {
				"i18nCaption": "expedientes",
				"filtro": { "i18nCaption": "cierre_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"ab03b10t00": {
				"i18nCaption": "expedientes",
				"maint": { "i18nCaption": "busqueda_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"tramitacion": {
				"i18nCaption": "expedientes",
				"maint": { "i18nCaption": "busqueda_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"ab03b03t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_cargos" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b04t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_firmantes" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b05t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_plantillas" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b39t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_organismos" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b41t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_tipos_material" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b44t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_tipos_documentos" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b53t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_tipos_trabajo" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b54t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_tipos_actividad" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b55t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_subtipos_actividad" },
				"subLevel": subLevelMantenimientos
			},
			"estadisticas": {
				"i18nCaption": "estadisticas",
				"estadTipoPlan": { "i18nCaption": "estadisticas_1" },
				"subLevel": subLevelEstadisticas
			},
			"estadisticasINSHT": {
				"i18nCaption": "estadisticas",
				"maint": { "i18nCaption": "estadisticas_2" },
				"subLevel": subLevelEstadisticas
			},
			"estadPercepcion": {
				"i18nCaption": "estadisticas",
				"maint": { "i18nCaption": "estadisticas_3" },
				"subLevel": subLevelEstadisticas
			}
		},
		initUrl: "start",
		i18nId: "ab03bAmiantoWar_migas",
		logOutUrl : $.rup.CTX_PATH + "logout"
	});
	
	//idioma
	$("#ab03bAmiantoWar_language").rup_language({languages: $.rup.AVAILABLE_LANGS_ARRAY, modo: "portal"});
	
	// linea en blanco de los combos
	$.rup.i18n.base.rup_combo.blankNotDefined = $.rup.i18n.app.mantenimientos.todas;//"--Todas--";
	
	//menu
	$("#ab03bAmiantoWar_menu").rup_menu({
		display: ($.rup.LAYOUT === "vertical" ? 'vertical' : 'horizontal')
	});
	if ($.rup.LAYOUT === "mixto") {
		$("#ab03bAmiantoWar_menu_mixto").rup_menu({
			display: 'vertical'
		});
	}
	
	//pie
	$(".footer [title]").rup_tooltip();
});